
#ifndef SST_EXT_ATP_INDEX_H
#define SST_EXT_ATP_INDEX_H


#include "SST_Ext_DEFINES.h"
#include "sst_types.h"
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */


#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 11 12:06:34 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_Ext_ATP_Index.h#1:incl:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Structs  ******************************/
/*Data operations test struct*/
typedef struct EXT_ATP_IndexTestDataStruct{  
    char              TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_Password[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_PasswordSizeInBytes;
    DxUint32_t                  TST_MaxNumOfTrials;
    DxUint8_t                   TST_Data[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint32_t                  TST_DataSize;
    DxChar_t                    TSTString1[TST_MAX_STRING_LENGTH];
    DxUint32_t                  TSTString1Size;
    DxChar_t                    TSTString2[TST_MAX_STRING_LENGTH];
    DxUint32_t                  TSTString2Size;
    DxChar_t                    TSTString3[TST_MAX_STRING_LENGTH];
    DxUint32_t                  TSTString3Size;
    DxChar_t                    TSTString4[TST_MAX_STRING_LENGTH];
    DxUint32_t                  TSTString4Size;
    DxChar_t                    TSTString5[TST_MAX_STRING_LENGTH];
    DxUint32_t                  TSTString5Size;
    DxUint32_t                  TST_MaxHandlesToRead1;
    DxUint32_t                  TST_MaxHandlesRead1;
    DxUint32_t                  TST_MaxHandlesToRead2;
    DxUint32_t                  TST_MaxHandlesRead2;
    DxUint32_t                  TST_MaxHandlesToRead3;
    DxUint32_t                  TST_MaxHandlesRead3;
    SSTHandle_t                 TSTRetHandles[TST_MAX_NUMBERS_OF_HANDLES_2READ];
    DxUint32_t                  NumOfMatches1;
    DxUint32_t                  NumOfMatches2;
    DxUint32_t                  NumOfMatches3;
} EXT_ATP_IndexTestDataStruct;
/*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_Index        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the Test the insertion, generation, reading, deletion, and usage of an AES symmetric key.
 *  
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/
  DxError_t SST_Ext_ATP_Index( void );
  
  
  
#ifdef __cplusplus
}
#endif

#endif







